﻿using System.ComponentModel;
using System.Windows.Media;
using System.Windows.Input;

namespace KoloryWPF.ModelWidoku
{
    using Model;

    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                OnPropertyChanged("G", "Color");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                OnPropertyChanged("B", "Color");
            }
        }

        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }

        /*
        public void Zapisz()
        {
            Ustawienia.Zapisz(kolor);
        }
        */

        private ICommand zapiszCommand;

        public ICommand Zapisz
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new RelayCommand(argument => { Ustawienia.Zapisz(kolor); });
                return zapiszCommand;
            }
        }

        private ICommand resetujCommand;

        /*
        public ICommand Resetuj
        {
            get
            {
                if (resetujCommand == null) resetujCommand = new ResetujCommand(this);
                return resetujCommand;
            }
        }
        */

        public ICommand Resetuj
        {
            get
            {
                if (resetujCommand == null)
                {
                    resetujCommand = new RelayCommand(
                        argument =>
                        {
                            R = 0;
                            G = 0;
                            B = 0;
                        },
                        argument => (R != 0) || (G != 0) || (B != 0)
                    );
                }
                return resetujCommand;
            }
        }

        public ICommand ZamknijOkno
        {
            get
            {
                //return new RelayCommand(argument => { App.Current.MainWindow.Close(); });
                return new RelayCommand(argument => { (argument as System.Windows.Window).Close(); });
            }
        }
    }

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return new Color()
            {
                A = 255,
                R = kolor.R,
                G = kolor.G,
                B = kolor.B
            };
        }
    }
}
